<?php

namespace App\Http\Controllers\LandingPage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\bnn_head;
use App\Models\division;
use App\Models\categorie;
use App\Models\profile;
use App\Models\setting;

class ProfileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        

      $divisi = division::all();
      $categorie = categorie::all();
      $profile = profile::all();
      
      $logo = setting::where('key','site.logo')->first('value');
      $logo = $logo->value;
      $alamat = setting::where('key','site.alamat')->first('value');
      $alamat = $alamat->value;
      $email = setting::where('key','site.email')->first('value');
      $email = $email->value;
      $no_hp = setting::where('key','site.no_hp')->first('value');
      $no_hp = $no_hp->value;
      $ig = setting::where('key','site.ig')->first('value');
      $ig = $ig->value;
      $twitter = setting::where('key','site.twitter')->first('value');
      $twitter = $twitter->value;
      $facebook = setting::where('key','site.facebook')->first('value');
      $facebook = $facebook->value;
      $website = setting::where('key','site.website')->first('value');
      $website = $website->value;
      $youtube = setting::where('key','site.youtube')->first('value');
      $youtube = $youtube->value;

      view()->share([
          'divs'     => $divisi,
          'informasi'     => $categorie,
          'prof' => $profile,
          'alamat' => $alamat,
          'email' => $email,
          'no_hp' => $no_hp,
          'logo' => $logo,
          'ig' => $ig,
          'twitter' => $twitter,
          'facebook' => $facebook,
          'website' => $website,
          'youtube' => $youtube,
      ]);

    }
    public function index()
    {
        //
        $bnn_head = bnn_head::all();
        
        return view('profile.about', compact('bnn_head'));  
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $bnn_head = bnn_head::all();

        $profile = profile::where('id',$id)->get();
        $divisi = division::where('id',$id)->get();
       
        return view('profile.index', compact('profile','bnn_head'));  
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
